# PRIVACY POLICY

**La Compte**  
Shop No. 19, First Floor Zaman Plaza, Westridge-1, Rawalpindi, Punjab, Pakistan

**Effective Date:** October 7, 2025  
**Last Updated:** October 7, 2025

---

## 1. INTRODUCTION

### 1.1 About This Policy

This Privacy Policy describes how La Compte (Registration No. 4682120, PSEB Registration Z-25-11315/24) collects, uses, stores, and protects personal information in accordance with the Constitution of Pakistan and applicable Pakistani laws, including the Prevention of Electronic Crimes Act, 2016.

### 1.2 Our Commitment

Privacy is a fundamental right under the Constitution of Pakistan. La Compte is committed to protecting the personal information of all clients, training participants, website visitors, and business contacts.

### 1.3 Scope

This policy applies to:
- Clients engaging La Compte for technology services
- Training program participants
- Website visitors to la-compte.com
- Business contacts and partners
- Job applicants

---

## 2. INFORMATION WE COLLECT

### 2.1 Personal Information

We collect the following types of personal information:

**Contact Information:**
- Full name
- Email address
- Phone number
- Mailing address
- CNIC (Computerized National Identity Card) number when required for contracts or training enrollment

**Business Information:**
- Company name and registration details
- Business address
- Tax identification numbers (NTN/STRN)
- Authorized representative details

**Financial Information:**
- Bank account details for payment processing
- Transaction records
- Payment receipts
- Invoicing information

**Training Participant Information:**
- Educational background
- Professional experience
- Attendance records
- Performance assessments
- Certificate issuance records

**Employment Application Information:**
- Resume/CV
- Educational certificates
- Professional references
- Work history

### 2.2 Technical Information

We automatically collect certain technical information when you visit our website:

- IP address
- Browser type and version
- Device information
- Pages visited and time spent
- Referring website
- Geographic location (city/region level)

### 2.3 Project and Service Data

For clients engaging our services, we may have access to:

- Database contents and structures
- Application source code
- Business documents and files
- Cloud infrastructure configurations
- Security audit information
- Website content and analytics

---

## 3. HOW WE COLLECT INFORMATION

### 3.1 Direct Collection

Information is collected directly when you:
- Submit inquiry forms on our website
- Enroll in training programs
- Sign service agreements
- Communicate via email or phone
- Submit payment information
- Apply for employment

### 3.2 Automatic Collection

Technical information is collected automatically through:
- Website cookies
- Server logs
- Analytics tools (Google Analytics)

### 3.3 Third-Party Sources

We may receive information from:
- Payment processors
- Government registration authorities
- Professional references (for employment)
- Business partners and referrals

---

## 4. HOW WE USE YOUR INFORMATION

### 4.1 Service Delivery

We use personal information to:
- Provide contracted technology services (web development, cloud solutions, database management, security services, data engineering)
- Deliver training programs
- Issue certificates and credentials
- Communicate about project progress
- Provide technical support

### 4.2 Business Operations

Information is used for:
- Contract administration
- Payment processing and invoicing
- Record-keeping and compliance
- Quality assurance and service improvement
- Internal reporting and analytics

### 4.3 Legal Compliance

We use information to:
- Comply with Pakistani tax laws and regulations
- Meet requirements of Pakistan Software Export Board (PSEB)
- Respond to legal requests from authorities
- Maintain business registration requirements
- Fulfill contractual obligations

### 4.4 Communication

Information is used to:
- Send service-related notifications
- Provide training schedules and updates
- Share relevant technical information
- Respond to inquiries
- Send invoices and payment confirmations

### 4.5 Marketing (With Consent Only)

We will only use your information for marketing purposes if you have provided explicit consent. Marketing communications may include:
- Newsletter about new services
- Training program announcements
- Technical blog posts and resources

You may withdraw consent at any time by contacting us at lacompte.general@gmail.com.

---

## 5. DATA STORAGE AND SECURITY

### 5.1 Storage Location

Personal information is stored:
- On secure servers within Pakistan where feasible
- On internationally recognized cloud platforms (Google Cloud, AWS, Azure) with appropriate security measures
- In encrypted databases
- In physical files at our registered office with restricted access

### 5.2 Security Measures

We implement the following security measures:

**Technical Safeguards:**
- Encryption of sensitive data (AES-256 or equivalent)
- Secure SSL/TLS connections for data transmission
- Regular security audits and vulnerability assessments
- Firewall protection and intrusion detection
- Access controls and authentication systems
- Regular backup procedures

**Administrative Safeguards:**
- Access limited to authorized personnel only
- Confidentiality agreements with all staff
- Security awareness training
- Incident response procedures
- Regular policy reviews

**Physical Safeguards:**
- Restricted access to physical files
- Secure storage facilities
- Visitor logs and access controls

### 5.3 Data Breach Procedures

In the event of a data breach that compromises personal information, we will:
- Investigate and contain the breach immediately
- Assess the scope and impact
- Notify affected individuals within 72 hours where feasible
- Report to relevant authorities as required by law
- Implement corrective measures to prevent recurrence

---

## 6. DATA SHARING AND DISCLOSURE

### 6.1 No Sale of Information

La Compte will never sell, rent, or trade your personal information to third parties for commercial purposes.

### 6.2 Service Providers

We may share limited information with trusted service providers who assist in business operations:

**Payment Processors:**
- Bank account information for payment processing
- Transaction details

**Cloud Service Providers:**
- Project data stored on AWS, Google Cloud, or Azure
- Technical infrastructure information

**Professional Services:**
- Accountants for tax compliance
- Legal advisors for contract review

All service providers are contractually obligated to maintain confidentiality and use information only for specified purposes.

### 6.3 Legal Requirements

We may disclose information when required by:
- Court orders or legal process
- Federal Board of Revenue (FBR) for tax compliance
- Pakistan Software Export Board (PSEB) for registration requirements
- Securities and Exchange Commission of Pakistan (SECP) if applicable
- Law enforcement agencies under Prevention of Electronic Crimes Act, 2016

### 6.4 Business Transfers

In the event of merger, acquisition, or sale of business assets, personal information may be transferred. You will be notified of any such change via email or website notice.

### 6.5 Client Authorization

For client project data, we will only share information with third parties when:
- Explicitly authorized in the service agreement
- Required for project delivery (e.g., hosting providers)
- Necessary for technical support
- Mandated by law

---

## 7. DATA RETENTION

### 7.1 Retention Periods

We retain personal information for the following periods:

**Client Service Data:**
- Duration of service agreement plus 7 years (for tax and legal compliance)
- Project documentation: 5 years after project completion

**Training Participant Data:**
- Duration of program plus 10 years (for certificate verification)
- Attendance and performance records: 5 years

**Financial Records:**
- 7 years (as required by Income Tax Ordinance, 2001)

**Employment Applications:**
- Successful candidates: Duration of employment plus 7 years
- Unsuccessful candidates: 1 year unless consent given for longer retention

**Website Analytics:**
- 26 months (Google Analytics default)

**Marketing Consent Records:**
- Until consent is withdrawn plus 1 year for compliance documentation

### 7.2 Secure Disposal

After retention periods expire, information is securely disposed of through:
- Secure deletion of digital records
- Shredding of physical documents
- Overwriting of storage media
- Certificate of destruction for sensitive materials

---

## 8. YOUR RIGHTS

### 8.1 Access Rights

You have the right to:
- Request confirmation of what personal information we hold
- Obtain a copy of your personal information
- Receive information about how your data is processed

Requests can be submitted to lacompte.general@gmail.com. We will respond within 30 days.

### 8.2 Correction Rights

You may request correction of:
- Inaccurate personal information
- Incomplete records
- Outdated contact details

### 8.3 Deletion Rights

You may request deletion of your personal information when:
- Information is no longer necessary for the purpose collected
- You withdraw consent (where consent was the basis for processing)
- Information was unlawfully processed

**Limitations:** We may not be able to delete information required for:
- Legal compliance (tax records, business registration)
- Contract fulfillment
- Legal claims or disputes
- Legitimate business interests

### 8.4 Objection Rights

You may object to:
- Marketing communications (opt-out at any time)
- Automated decision-making (if applicable)
- Processing based on legitimate interests

### 8.5 Data Portability

Upon request, we will provide your personal information in a structured, commonly used, and machine-readable format (CSV, JSON, or PDF) where technically feasible.

### 8.6 Exercising Your Rights

To exercise any of these rights:
- Email: lacompte.general@gmail.com
- Phone: +92 336 0587451
- Written request to: Shop No. 19, First Floor Zaman Plaza, Westridge-1, Rawalpindi

We may require CNIC verification to confirm identity before fulfilling requests.

---

## 9. COOKIES AND TRACKING TECHNOLOGIES

### 9.1 Use of Cookies

Our website (la-compte.com) uses cookies for:
- Website functionality and navigation
- Analytics and performance monitoring
- User preference storage

### 9.2 Types of Cookies

**Essential Cookies:**
- Required for website operation
- Cannot be disabled

**Analytics Cookies:**
- Google Analytics for website traffic analysis
- Can be disabled through browser settings

**Functional Cookies:**
- Remember user preferences
- Improve user experience

### 9.3 Cookie Management

You can control cookies through:
- Browser settings (disable/delete cookies)
- Google Analytics opt-out: https://tools.google.com/dlpage/gaoptout

Disabling cookies may limit website functionality.

---

## 10. THIRD-PARTY WEBSITES

### 10.1 External Links

Our website may contain links to third-party websites. We are not responsible for the privacy practices of external sites. We recommend reviewing their privacy policies before providing personal information.

### 10.2 Third-Party Services

We use the following third-party services:
- Google Analytics (website analytics)
- WordPress.com (website hosting)
- Payment gateways (as specified in service agreements)

Each service has its own privacy policy governing data handling.

---

## 11. CHILDREN'S PRIVACY

### 11.1 Age Restrictions

La Compte services and training programs are intended for individuals aged 18 and above. We do not knowingly collect personal information from minors under 18 without parental consent.

### 11.2 Parental Consent

If a training participant is under 18:
- Written parental consent is required
- Parents/guardians may access the minor's information
- Parents/guardians may request deletion of information

### 11.3 Discovery of Minor Data

If we discover that personal information has been collected from a minor without appropriate consent, we will delete such information immediately.

---

## 12. INTERNATIONAL DATA TRANSFERS

### 12.1 Applicable Legal Framework

**Pakistani Law Requirements:**

Under Pakistan's draft Personal Data Protection Bill, 2023, and current best practices:

- **Critical Personal Data**: Cannot be transferred outside Pakistan and must be processed only on servers/data centers located within Pakistan
- **Sensitive Personal Data**: May be transferred with appropriate safeguards and Commission-approved mechanisms (when National Commission for Personal Data Protection is established)
- **General Personal Data**: May be transferred when adequate protection exists

**International Law Compliance:**

When processing personal data of EU residents, La Compte complies with the General Data Protection Regulation (GDPR):

- **Article 44-50 GDPR**: Cross-border data transfer requirements
- **Standard Contractual Clauses (SCCs)**: Implemented for EU data transfers
- **Adequacy Assessment**: Ensuring destination countries provide adequate protection
- **Data Subject Rights**: Respecting EU residents' rights regardless of processing location

### 12.2 When International Transfers Occur

Personal information may be transferred internationally in the following circumstances:

**Cloud Service Infrastructure:**
- Storage on AWS, Google Cloud, or Azure platforms with servers outside Pakistan
- Content delivery networks (CDNs) for website performance
- Backup and disaster recovery systems

**Client Service Delivery:**
- International clients requiring data processing in their jurisdictions
- Cross-border project collaboration
- Global application deployment

**Business Operations:**
- Payment processing through international gateways
- Email services (Google Workspace)
- Professional service providers (accounting, legal)

### 12.3 Safeguards for International Transfers

We implement the following safeguards for all international data transfers:

**Legal Mechanisms:**
- Standard Contractual Clauses (SCCs) approved by European Commission
- Data Processing Agreements with all service providers
- Explicit client authorization documented in service agreements
- Binding contractual obligations on third parties

**Technical Safeguards:**
- End-to-end encryption (AES-256 or equivalent) for data in transit
- Encryption at rest on all cloud storage
- Secure VPN connections for data access
- Multi-factor authentication for system access
- Regular security audits of third-party providers

**Organizational Safeguards:**
- Documented data transfer impact assessments
- Regular review of service provider compliance
- Staff training on international data protection requirements
- Incident response procedures for cross-border data breaches

### 12.4 EU-Pakistan Data Transfers (GDPR Compliance)

When processing personal data of individuals located in the European Union, La Compte ensures GDPR compliance:

**Lawful Basis for Processing:**
- Explicit consent from data subjects
- Contractual necessity
- Legitimate interests (with documented balancing test)
- Legal obligations

**Transfer Mechanisms:**
- Standard Contractual Clauses (SCCs) - Commission Decision 2021/914
- Supplementary measures when required by European Data Protection Board guidance
- Documentation of necessity for each transfer
- Alternative measures if adequacy decision is not available

**Data Subject Rights (EU Residents):**
- Right to access data processed by La Compte
- Right to rectification of inaccurate data
- Right to erasure ("right to be forgotten")
- Right to data portability in machine-readable format
- Right to object to processing
- Right not to be subject to automated decision-making

**GDPR-Specific Obligations:**
- Data Protection Impact Assessments (DPIAs) for high-risk processing
- Records of Processing Activities maintained
- Data breach notification within 72 hours to supervisory authority
- Cooperation with EU Data Protection Authorities
- Potential appointment of EU representative if required

### 12.5 Critical and Sensitive Data Localization

In accordance with Pakistan's draft Personal Data Protection Bill requirements:

**Critical Personal Data:**
- Financial transaction data of Pakistani residents
- Health records of Pakistani citizens
- Government-issued identification credentials
- Data relating to national security

**Processing Location:** All critical personal data is processed exclusively on servers located within Pakistan. La Compte maintains infrastructure within Pakistan for processing such data.

**Sensitive Personal Data:**
- Religious or philosophical beliefs
- Racial or ethnic origin
- Political opinions
- Trade union membership
- Genetic or biometric data
- Sexual orientation or sex life
- Health information

**Localization Mechanism:** Copies of sensitive personal data are retained on servers within Pakistan even when transfers occur for legitimate purposes. The National Commission for Personal Data Protection (when established) will prescribe specific retention mechanisms.

### 12.6 Client Authorization and Transparency

Before any international transfer of client data, we:

**Disclosure Requirements:**
- Inform clients in writing of proposed transfer destinations
- Specify the countries where data will be stored/processed
- Identify third-party service providers involved
- Explain the purpose and duration of transfer
- Describe safeguards implemented

**Authorization Process:**
- Obtain explicit written authorization from clients
- Document client consent in service agreements
- Provide clients with copies of relevant SCCs or data processing agreements
- Allow clients to refuse or withdraw authorization
- Offer alternative solutions for clients requiring data localization

**Ongoing Transparency:**
- Notify clients of any changes to data storage locations
- Provide annual reports on international data transfers upon request
- Maintain accessible records of all third-party processors
- Inform clients of any data breaches affecting transferred data

### 12.7 Service Provider Due Diligence

We conduct thorough due diligence on all international service providers:

**Assessment Criteria:**
- ISO 27001 certification or equivalent security standards
- SOC 2 Type II compliance reports
- Privacy Shield or adequacy decision status (EU transfers)
- Track record of data protection compliance
- Existence of robust security infrastructure
- Data breach history and incident response capabilities

**Contractual Requirements:**
- Data processing agreements specifying purpose limitations
- Confidentiality obligations on all personnel
- Sub-processor approval requirements
- Audit rights for La Compte and regulatory authorities
- Data return or deletion obligations upon contract termination
- Indemnification for data breaches caused by processor

### 12.8 Monitoring and Compliance

We continuously monitor international data transfers:

**Regular Reviews:**
- Quarterly assessment of service provider compliance
- Annual review of Standard Contractual Clauses validity
- Monitoring of regulatory developments (GDPR, Pakistani law)
- Assessment of geopolitical risks to data protection

**Documentation:**
- Transfer Impact Assessments for each category of transfers
- Records of basis for each transfer (consent, contract, etc.)
- Documentation of supplementary measures implemented
- Client authorization records maintained for 7 years

**Compliance Actions:**
- Immediate suspension of transfers if adequacy is compromised
- Notification to affected data subjects and clients
- Implementation of alternative transfer mechanisms
- Cooperation with Pakistani and EU regulatory authorities

### 12.9 Restrictions on Data Access

We implement strict controls on international data access:

**Access Limitations:**
- Data access restricted to employees/contractors with legitimate need
- Geographic restrictions on system access where feasible
- Logging and monitoring of all data access activities
- Regular access reviews and revocation procedures

**Government Access Requests:**
- Assessment of legal basis for government requests
- Notification to affected clients (unless legally prohibited)
- Challenge of overly broad or unlawful requests
- Documentation of all government data requests and responses
- Transparency reporting (annual disclosure of requests where permitted)

**Conflicts of Law:**
- If Pakistani law conflicts with GDPR or destination country law, we prioritize the strictest data protection standard
- Legal assessment conducted for each conflicting obligation
- Notification to affected parties of conflict and resolution
- Documentation of legal analysis and decision rationale

---

## 13. COMPLIANCE WITH PAKISTANI AND INTERNATIONAL LAW

### 13.1 Pakistani Legislation Compliance

This Privacy Policy complies with:

**Constitutional Law:**
- Article 14 of the Constitution of Pakistan (fundamental right to privacy)
- Supreme Court precedent on privacy as an inalienable right

**Cybercrime and Data Protection:**
- Prevention of Electronic Crimes Act, 2016 (PECA)
  - Section 36: Unauthorized access to information systems
  - Section 37: Malicious code
  - Sections on unauthorized data use and transmission
- Personal Data Protection Bill, 2023 (draft - best practices implementation)
  - Data subject rights framework
  - Data controller and processor obligations
  - Cross-border transfer requirements
  - Breach notification procedures

**Financial and Tax Compliance:**
- Income Tax Ordinance, 2001 (record-keeping requirements - 7 year retention)
- Banking Companies Ordinance, 1962 (financial data confidentiality)
- Payment Systems and Electronic Fund Transfers Act, 2007 (consumer data protection)

**Regulatory Compliance:**
- Pakistan Software Export Board (PSEB) regulations
- Pakistan Telecommunication Authority (PTA) regulations
- Securities and Exchange Commission of Pakistan (SECP) requirements
- Listed Companies (Code of Corporate Governance) Regulations, 2019 (whistle-blowing policy framework)

**E-Safety and Digital Rights:**
- E-Safety Bill 2023 provisions (pending approval - proactive compliance)
- PECA 2025 amendments (Section 26A on false information dissemination)

### 13.2 International Data Protection Law Compliance

**European Union - GDPR:**

When La Compte processes personal data of individuals located in the EU, we comply with:

- **Regulation (EU) 2016/679** - General Data Protection Regulation
- **Territorial Scope (Article 3)**: Applies when offering goods/services to EU data subjects or monitoring their behavior
- **Legal Basis (Article 6)**: Processing only on lawful grounds (consent, contract, legitimate interest, legal obligation)
- **Special Categories (Article 9)**: Enhanced protection for sensitive data
- **Data Subject Rights (Articles 12-23)**: Access, rectification, erasure, portability, objection
- **Data Protection by Design and Default (Article 25)**
- **Data Protection Impact Assessments (Article 35)**: For high-risk processing
- **Breach Notification (Articles 33-34)**: 72-hour notification requirement
- **Cross-Border Transfers (Articles 44-50)**: Standard Contractual Clauses, adequacy decisions
- **Accountability Principle (Article 5(2))**: Documented compliance measures

**EU Representative:**
- If La Compte regularly processes EU personal data, we will appoint an EU-based representative as required by Article 27 GDPR
- Current assessment: Monitoring for trigger thresholds

**Cooperation with EU Data Protection Authorities:**
- Cooperation with supervisory authorities upon request
- Response to data subject complaints forwarded by EU authorities
- Participation in mutual assistance mechanisms
- Implementation of binding decisions from EU Data Protection Board

**Other International Frameworks:**

**ISO/IEC 27001:2022** - Information Security Management
- Implementation of controls from Annex A
- Risk-based approach to information security
- Continuous improvement process

**ISO/IEC 27701:2019** - Privacy Information Management
- Extension to ISO 27001 for privacy management
- PII controller and processor requirements
- Alignment with GDPR principles

**ISO/IEC 27018:2019** - Cloud Privacy
- Protection of PII in public cloud environments
- Transparency requirements for cloud services
- Implementation when using AWS, Google Cloud, Azure

**NIST Privacy Framework** (U.S.)
- Privacy risk assessment methodologies
- Core privacy activities implementation
- Voluntary best practices adoption

### 13.3 Sector-Specific Compliance

**Financial Services:**
- State Bank of Pakistan (SBP) Regulations:
  - Payment Card Security Regulations
  - Internet Banking Security Regulations
  - Consumer data confidentiality requirements
- Anti-Money Laundering (AML) compliance when processing financial data
- Know Your Customer (KYC) requirements for financial sector clients

**Healthcare Data:**
- Medical and Dental Council ordinances (confidentiality)
- Hospital data protection best practices
- HIPAA-inspired controls for international healthcare clients
- Special category data handling under GDPR Article 9

**Education Sector:**
- Student data protection standards
- Children's privacy (enhanced protection for under-18)
- FERPA-inspired controls for international education clients

**Telecommunications:**
- PTA Telecom Consumer Protection Regulations, 2009 (Regulation 16)
- Consumer information confidentiality
- Data retention requirements for telecom services

### 13.4 Regulatory Cooperation and Oversight

We cooperate with the following regulatory authorities:

**Pakistani Authorities:**

**Federal Board of Revenue (FBR)**
- Tax compliance reporting
- Record retention as required
- Response to information requests
- Annual tax return filing (La Compte NTN: 4682120)

**Pakistan Software Export Board (PSEB)**
- Registration renewal (Z-25-11315/24, valid May 2024 - April 2025)
- Compliance with export regulations
- Industry reporting requirements
- Participation in PSEB initiatives

**Federal Investigation Agency (FIA) - Cybercrime Wing**
- Cooperation with cybercrime investigations
- Reporting of serious data breaches
- Assistance with digital forensics when required
- Compliance with PECA enforcement

**Pakistan Telecommunication Authority (PTA)**
- Compliance with telecom regulations
- Website and online services compliance
- Response to consumer complaints escalated to PTA

**Securities and Exchange Commission of Pakistan (SECP)**
- Corporate governance compliance (if applicable)
- Disclosure requirements
- Whistle-blowing policy implementation

**National Commission for Personal Data Protection (NCPDP)**
- When established under Personal Data Protection Bill
- Registration as data controller/processor
- Compliance with Commission standards and mechanisms
- Response to complaints and investigations
- Submission to audits and assessments

**International Authorities:**

**European Data Protection Authorities**
- Lead supervisory authority identified based on main establishment
- Cooperation under GDPR mutual assistance provisions
- Response to cross-border enforcement actions
- Implementation of decisions and corrective measures

**European Data Protection Board (EDPB)**
- Monitoring of guidance and opinions
- Implementation of binding decisions
- Adherence to consistency mechanism

### 13.5 Compliance Monitoring and Auditing

**Internal Compliance:**
- Quarterly privacy policy review and update assessment
- Annual comprehensive compliance audit
- Data protection impact assessments for new processing activities
- Regular staff training on privacy requirements
- Documented compliance procedures and checklists

**External Audits:**
- Third-party security audits (annual)
- ISO certification audits (when pursued)
- Regulatory audits by PSEB, FBR, or other authorities
- Client-requested compliance assessments

**Documentation:**
- Records of Processing Activities (GDPR Article 30)
- Data transfer impact assessments
- Consent records and authorizations
- Breach notification logs
- Training completion records
- Policy review and update history

### 13.6 Legal Updates and Policy Evolution

**Monitoring Legal Developments:**
- Active monitoring of Pakistani legislative developments
- Tracking of Personal Data Protection Bill progress
- GDPR case law and regulatory guidance review
- International data protection trend analysis

**Policy Updates:**
- Immediate compliance updates when Pakistani law enacted
- Adaptation to GDPR guidance and EDPB decisions
- Incorporation of industry best practices
- Response to regulatory enforcement trends

**Stakeholder Communication:**
- Client notification of material legal changes
- Updated guidance on data protection obligations
- Transparency about evolving compliance landscape
- Consultation on implementation of new requirements

### 13.7 Cross-Border Legal Conflicts

**Conflict Resolution Framework:**

When obligations under Pakistani law conflict with GDPR or other international requirements:

1. **Legal Assessment**: Documented analysis of conflicting provisions
2. **Highest Standard**: Default to strictest data protection requirement
3. **Stakeholder Notification**: Inform affected clients and data subjects
4. **Regulatory Consultation**: Engage with relevant authorities
5. **Alternative Solutions**: Implement technical or organizational measures to satisfy both regimes
6. **Documentation**: Maintain records of conflict analysis and resolution

**Government Access Conflicts:**
- If Pakistani government demands data access that conflicts with GDPR, we will:
  - Assess legal basis under both frameworks
  - Seek to narrow scope of request
  - Notify affected EU data subjects (unless legally prohibited)
  - Challenge overly broad requests where legally permissible
  - Document rationale for disclosure decision

### 13.8 Industry Standards and Best Practices

Beyond legal requirements, we voluntarily adopt:

**OWASP (Open Web Application Security Project)**
- Top 10 security risk mitigation
- Secure coding practices
- Application security testing

**CIS (Center for Internet Security) Controls**
- Implementation of critical security controls
- Baseline security configurations
- Continuous vulnerability management

**Cloud Security Alliance (CSA)**
- Cloud Controls Matrix implementation
- Cloud security best practices
- Trusted cloud provider assessment

**PSEB Recommended Practices**
- Export documentation standards
- Quality assurance frameworks
- Client relationship management guidelines

---

## 14. BUSINESS CONTACT INFORMATION

### 14.1 La Compte Details

**Company Name:** La Compte  
**Registration Number:** 4682120  
**Registration Type:** Association of Persons  
**PSEB Registration:** Z-25-11315/24 (Valid: May 2024 - April 2025)  
**Tax Office:** RTO Rawalpindi

**Principal Officers:**
- Shehroze Ameen (Principal Officer)
- Fauzia Moghees (Partner)

**Registered Address:**  
Shop No. 19, First Floor Zaman Plaza  
Westridge-1, Rawalpindi  
Punjab, Pakistan

**Contact Information:**  
Phone: +92 336 0587451  
Email: lacompte.general@gmail.com  
Website: la-compte.com

### 14.2 Privacy Inquiries

For privacy-related questions or concerns:
- Email: lacompte.general@gmail.com (Subject: Privacy Inquiry)
- Phone: +92 336 0587451
- Written correspondence to registered address above

We will respond to privacy inquiries within 30 days.

---

## 15. COMPLAINTS AND DISPUTE RESOLUTION

### 15.1 Internal Complaints

If you believe your privacy rights have been violated:

**Step 1:** Contact us at lacompte.general@gmail.com with details of the concern  
**Step 2:** We will acknowledge receipt within 5 business days  
**Step 3:** Investigation will be completed within 30 days  
**Step 4:** Written response will be provided with findings and corrective actions

### 15.2 External Recourse

If unsatisfied with our response, you may:
- File a complaint with FIA Cybercrime Wing
- Seek legal remedy through civil courts in Rawalpindi
- Contact Pakistan Software Export Board (PSEB)

### 15.3 Dispute Resolution

Disputes arising from this Privacy Policy are subject to:
- Pakistani law
- Exclusive jurisdiction of courts in Rawalpindi, Pakistan
- Good faith negotiation before litigation

---

## 16. CHANGES TO THIS PRIVACY POLICY

### 16.1 Policy Updates

We may update this Privacy Policy to reflect:
- Changes in business practices
- New service offerings
- Legal or regulatory requirements
- Technology changes
- Industry best practices

### 16.2 Notification of Changes

**Material Changes:**
- Email notification to active clients and participants
- Prominent website notice for 30 days
- Updated "Last Updated" date at top of policy

**Minor Changes:**
- Website update with revised date
- No individual notification required

### 16.3 Continued Use

Continued use of La Compte services after policy changes constitutes acceptance of revised terms. If you do not agree with changes, discontinue use and contact us regarding data deletion.

---

## 17. CONTACT INFORMATION

### 17.1 Privacy Officer

For privacy-related matters, contact:

**Principal Officer:** Shehroze Ameen  
**Email:** lacompte.general@gmail.com  
**Phone:** +92 336 0587451  
**Address:** Shop No. 19, First Floor Zaman Plaza, Westridge-1, Rawalpindi, Punjab, Pakistan

### 17.2 Business Hours

Monday - Saturday: 9:00 AM - 6:00 PM PKT  
Sunday: Closed  
Public Holidays: Closed

### 17.3 Response Times

- Privacy inquiries: Within 30 days
- Data breach notifications: Within 72 hours
- Access requests: Within 30 days
- Correction requests: Within 14 days
- Deletion requests: Within 30 days (subject to legal retention requirements)

---

## 18. ACKNOWLEDGMENT

By engaging La Compte services, enrolling in training programs, or using our website, you acknowledge that you have read, understood, and agree to the terms of this Privacy Policy.

---

**Document Control:**
- Version: 1.0
- Effective Date: October 7, 2025
- Last Reviewed: October 7, 2025
- Next Review Date: October 7, 2026
- Approved By: Shehroze Ameen, Principal Officer

---

**END OF PRIVACY POLICY**